# Kioju Firefox Extension

Firefox browser extension for sharing interesting web pages with your Kioju server.

## Features

- **One-click sharing**: Share the current page with a single click
- **Pre-configured setup**: Server URL is pre-configured, just add your API key
- **Intelligent rate limiting**: Respects your account's rate limits with helpful feedback
- **Premium support**: Enhanced rate limits and features for premium users
- **Cross-browser compatibility**: Same functionality as the Chrome extension

## Installation

### Development/Manual Installation

1. **Download the extension**: Get the extension files from your Kioju account
2. **Extract the files**: Unzip the `kioju-firefox-extension.zip` file
3. **Open Firefox**: Launch Firefox browser
4. **Access Add-ons**: Navigate to `about:debugging` in your address bar
5. **Enable debugging**: Click "This Firefox" in the left sidebar
6. **Load temporary add-on**: Click "Load Temporary Add-on..."
7. **Select manifest**: Browse to the extracted folder and select `manifest.json`
8. **Extension installed**: The extension will appear in your toolbar

### Configuration

1. **Click the extension icon** in your Firefox toolbar
2. **Open settings**: Click "Extension Settings" in the popup
3. **Add API key**: Enter your API key from your Kioju profile page
4. **Save**: Click "Save Settings"
5. **Test**: Visit any webpage and click "Share Current Page" to test

## Usage

1. **Navigate** to any interesting webpage
2. **Click** the Kioju extension icon in your toolbar
3. **Share**: Click "Share Current Page" to add it to your collection
4. **Success**: The extension will confirm when the link is saved

## Rate Limits

The extension respects your account's rate limits:

- **Free users**: 25 submissions per hour
- **Premium users**: 100 submissions per hour

The extension will show helpful messages about your current usage and when limits reset.

## Troubleshooting

### "Please set your API key in extension settings"
- Go to extension settings and enter your API key from your Kioju profile

### "Rate limit exceeded"
- Wait for the reset time or upgrade to premium for higher limits

### "Network error"
- Check your internet connection and try again

### Extension not working on certain sites
- Some sites (like `about:` pages) restrict extension access
- You can always manually add links through the Kioju website

## Support

- **FAQ**: Visit the Kioju FAQ page for detailed troubleshooting
- **Contact**: Reach out through your Kioju account for support

## Version

Current version: 2.3

## Compatibility

- Firefox 57.0 and newer
- All modern web pages (some restrictions on internal browser pages)
- Same API and features as Chrome extension
