// This script handles the options page for the Kioju extension.
// It only needs to save the API key since the server URL is fixed.

document.addEventListener('DOMContentLoaded', function () {
  const apiKeyInput = document.getElementById('apiKey');
  const statusDiv = document.getElementById('status');

  // Fixed server URL - no need to expose this to users
  const serverUrl = 'https://kioju.de/api/api.php';

  // Restore previously saved API key
  chrome.storage.sync.get(['apiKey'], function (data) {
    if (data.apiKey) apiKeyInput.value = data.apiKey;
  });

  // Save button handler
  document.getElementById('saveBtn').addEventListener('click', function () {
    const apiKey = apiKeyInput.value.trim();

    // Basic validation
    if (!apiKey) {
      showStatus('Please enter your API key.', 'error');
      apiKeyInput.focus();
      return;
    }

    // Validate API key format (basic check)
    if (apiKey.length < 10) {
      showStatus('API key seems too short. Please check your key.', 'error');
      apiKeyInput.focus();
      return;
    }

    // Save both the API key and the fixed server URL
    chrome.storage.sync.set({ serverUrl, apiKey }, function () {
      showStatus('✅ Settings saved successfully! You can now use the extension.', 'success');
    });
  });

  function showStatus(message, type) {
    statusDiv.textContent = message;
    statusDiv.className = type;
    statusDiv.style.display = 'block';

    setTimeout(() => {
      statusDiv.style.display = 'none';
    }, 4000);
  }
});