# Kioju Chrome Extension

A Chrome browser extension that allows you to quickly share the current page with your Kioju server.

## Features

- 🚀 **One-click sharing** of the current webpage (Free & Premium)
- 🔗 **Automatic title detection** from the page
- 🔐 **Secure API authentication** with your Kioju server
- ⚙️ **Simplified setup** - just add your API key!
- 🎨 **Modern Kioju design** - matches the main website
- 📱 **Intuitive interface** with easy access to settings
- 💎 **Premium API features** - List and delete links via API (Premium only)

## Installation

### Method 1: Developer Mode (Recommended)
1. Download and extract the `kioju-chrome-extension.zip` file
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable **Developer mode** (toggle in top-right corner)
4. Click **"Load unpacked"**
5. Select the extracted `chrome_extension` folder
6. The extension will be installed and ready to use

### Method 2: From ZIP file
1. Download the `kioju-chrome-extension.zip` file
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable **Developer mode** (toggle in top-right corner)
4. Drag and drop the ZIP file onto the extensions page

## Configuration

**Super Simple Setup!** The extension is pre-configured for Kioju - you only need to add your API key:

1. Click the Kioju extension icon in your browser toolbar
2. Click **"Extension Settings"** button
3. Enter your **API Key** (get this from your Kioju profile page)
4. Click **"Save Settings"**

That's it! The server URL is automatically configured - no manual setup needed.

## API Features

### Free Features
- ✅ **Add Links**: Submit any webpage to your Kioju account instantly

### Premium Features 💎
- ✅ **List Links**: Retrieve all your links via API
- ✅ **Delete Links**: Remove links programmatically
- ✅ **Higher Rate Limits**: 100 submissions/hour vs 25 for free users
- ✅ **Advanced Integrations**: Build custom tools with full API access

## Usage

1. Navigate to any webpage you want to share
2. Click the Kioju extension icon in your toolbar
3. Click **"Share Current Page"**
4. The page will be added to your Kioju account
5. Visual status messages will show success or any errors

**💡 Pro Tip**: After adding links with the extension, visit your Kioju dashboard to organize them into Collections for better discovery and sharing!

## API Key Setup

To get your API key:
1. Log into your Kioju account at https://kioju.de/
2. Go to your **Profile** page
3. Find the "🔑 API Access" section
4. Copy your API key and paste it into the extension settings

## What's New in This Version

- 🎨 **Updated Design**: Matches the beautiful Kioju website design
- 🔧 **Simplified Setup**: Server URL is pre-configured - just add your API key!
- 📱 **Better Interface**: Modern card-based layout with Kioju branding
- ⚙️ **Easy Settings Access**: Direct button to settings from the popup
- ✅ **Enhanced Feedback**: Better visual feedback for success and error states
- 🔒 **Improved Validation**: Smart validation for API keys

## Permissions

The extension requires the following permissions:
- **activeTab**: To access the current tab's URL and title
- **storage**: To save your API key settings
- **scripting**: For enhanced functionality
- **host_permissions**: To communicate with your Kioju server

## Troubleshooting

### "Please enter your API key"
- The server URL is pre-configured, you only need to add your API key
- Get your API key from your Kioju profile page

### "Invalid API key"
- Check that your API key is correct
- Ensure your Kioju account is verified
- Try regenerating your API key from the profile page

### Rate Limited Messages
If you see "Rate limit: X/Y submissions used. Try again in X minutes":
- **Free users**: 25 submissions per hour (perfect for normal browsing)  
- **Premium users**: 100 submissions per hour (great for research sessions)
- **Why**: Kioju uses tiered limits to prevent spam while supporting legitimate usage
- **What to do**: Wait for the specified time, or consider upgrading to Premium for higher limits
- **Pro tip**: Use Collections to organize links you've already submitted rather than submitting duplicates
- **When it resets**: Rate limits reset exactly one hour after your first submission in the current hour

### "Error sending request"
- Verify your Kioju account is active
- Check your internet connection
- Make sure you're using the latest version of the extension

## Support

For support and bug reports, please use the contact form at https://kioju.de/contact.php

---

**Version**: 2.0  
**Compatible with**: Chrome, Chromium-based browsers  
**Kioju Version**: Compatible with Kioju v2.0+ servers  
**What's New**: Redesigned interface, simplified setup, pre-configured server URL
